/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others. All rights reserved.
 * The contents of this file are made available under the terms
 * of the GNU Lesser General Public License (LGPL) Version 2.1 that
 * accompanies this distribution (lgpl-v21.txt).  The LGPL is also
 * available at http://www.gnu.org/licenses/lgpl.html.  If the version
 * of the LGPL at http://www.gnu.org is different to the version of
 * the LGPL accompanying this distribution and there is any conflict
 * between the two license versions, the terms of the LGPL accompanying
 * this distribution shall govern.
 *******************************************************************************/
package org.eclipse.swt.internal.gtk;

 
import org.eclipse.swt.internal.Library;

public class OS {
	static {
		Library.loadLibrary("swt-pi");
	}
	
	/** Constants */
	public static final int G_SIGNAL_MATCH_DATA = 1 << 4;
	public static final int GDK_2BUTTON_PRESS = 0x5;
	public static final int GDK_3BUTTON_PRESS = 0x6;
	public static final int GDK_ACTION_COPY = 1 << 1;
	public static final int GDK_ACTION_MOVE = 1 << 2;
	public static final int GDK_ACTION_LINK = 1 << 3;
	public static final int GDK_Alt_L = 0xffe9;
	public static final int GDK_Alt_R = 0xffea;
	public static final int GDK_BackSpace = 0xff08;
	public static final int GDK_BOTTOM_LEFT_CORNER = 0xc;
	public static final int GDK_BOTTOM_RIGHT_CORNER = 0xe;
	public static final int GDK_BOTTOM_SIDE = 0x10;
	public static final int GDK_BUTTON1_MASK = 0x100;
	public static final int GDK_BUTTON2_MASK = 0x200;
	public static final int GDK_BUTTON3_MASK = 0x400;
	public static final int GDK_BUTTON_PRESS = 0x4;
	public static final int GDK_BUTTON_PRESS_MASK = 0x100;
	public static final int GDK_BUTTON_RELEASE = 0x7;
	public static final int GDK_BUTTON_RELEASE_MASK = 0x200;
	public static final int GDK_CAP_BUTT = 0x1;
	public static final int GDK_COLORSPACE_RGB = 0;
	public static final int GDK_CONTROL_MASK = 0x4;
	public static final int GDK_COPY = 0x0;
	public static final int GDK_CROSS = 0x1e;
	public static final int GDK_CROSSING_NORMAL = 0;
	public static final int GDK_Cancel = 0xff69;
	public static final int GDK_Clear = 0xff0B;
	public static final int GDK_Control_L = 0xffe3;
	public static final int GDK_Control_R = 0xffe4;
	public static final int GDK_CURRENT_TIME = 0x0;
	public static final int GDK_DECOR_BORDER = 0x2;
	public static final int GDK_DECOR_MAXIMIZE = 0x40;
	public static final int GDK_DECOR_MENU = 0x10;
	public static final int GDK_DECOR_MINIMIZE = 0x20;
	public static final int GDK_DECOR_RESIZEH = 0x4;
	public static final int GDK_DECOR_TITLE = 0x8;
	public static final int GDK_DIAMOND_CROSS = 0x24;
	public static final int GDK_DOUBLE_ARROW = 0x2a;
	public static final int GDK_Delete = 0xffff;
	public static final int GDK_Down = 0xff54;
	public static final int GDK_ENTER_NOTIFY_MASK = 0x1000;
	public static final int GDK_EXPOSURE_MASK = 0x2;
	public static final int GDK_End = 0xff57;
	public static final int GDK_Escape = 0xff1b;
	public static final int GDK_F1 = 0xffbe;
	public static final int GDK_F10 = 0xffc7;
	public static final int GDK_F11 = 0xffc8;
	public static final int GDK_F12 = 0xffc9;
	public static final int GDK_F2 = 0xffbf;
	public static final int GDK_F3 = 0xffc0;
	public static final int GDK_F4 = 0xffc1;
	public static final int GDK_F5 = 0xffc2;
	public static final int GDK_F6 = 0xffc3;
	public static final int GDK_F7 = 0xffc4;
	public static final int GDK_F8 = 0xffc5;
	public static final int GDK_F9 = 0xffc6;
	public static final int GDK_FOCUS_CHANGE = 0xc;
	public static final int GDK_FOCUS_CHANGE_MASK = 0x4000;
	public static final int GDK_GC_CLIP_MASK = 0x80;
	public static final int GDK_GC_CLIP_X_ORIGIN = 0x800;
	public static final int GDK_GC_CLIP_Y_ORIGIN = 0x1000;
	public static final int GDK_GRAB_SUCCESS = 0x0;
	public static final int GDK_HAND1 = 0x3a;
	public static final int GDK_Home = 0xff50;
	public static final int GDK_INCLUDE_INFERIORS = 0x1;
	public static final int GDK_INTERP_BILINEAR = 0x2;
	public static final int GDK_Insert = 0xff63;
	public static final int GDK_ISO_Left_Tab = 0xfe20;
	public static final int GDK_JOIN_MITER = 0x0;
	public static final int GDK_KEY_PRESS = 0x8;
	public static final int GDK_KEY_PRESS_MASK = 0x400;
	public static final int GDK_KEY_RELEASE = 0x9;
	public static final int GDK_KEY_RELEASE_MASK = 0x800;
	public static final int GDK_KP_0 = 0xffb0;
	public static final int GDK_KP_1 = 0xffb1;
	public static final int GDK_KP_2 = 0xffb2;
	public static final int GDK_KP_3 = 0xffb3;
	public static final int GDK_KP_4 = 0xffb4;
	public static final int GDK_KP_5 = 0xffb5;
	public static final int GDK_KP_6 = 0xffb6;
	public static final int GDK_KP_7 = 0xffb7;
	public static final int GDK_KP_8 = 0xffb8;
	public static final int GDK_KP_9 = 0xffb9;
	public static final int GDK_KP_Add = 0xffab;
	public static final int GDK_KP_Decimal = 0xffae;
	public static final int GDK_KP_Divide = 0xffaf;
	public static final int GDK_KP_Enter = 0xff8d;
	public static final int GDK_KP_Multiply = 0xffaa;
	public static final int GDK_KP_Subtract = 0xffad;
	public static final int GDK_LEAVE_NOTIFY_MASK = 0x2000;
	public static final int GDK_LEFT_PTR = 0x44;
	public static final int GDK_LEFT_SIDE = 0x46;
	public static final int GDK_LINE_DOUBLE_DASH = 0x2;
	public static final int GDK_LINE_ON_OFF_DASH = 0x1;
	public static final int GDK_LINE_SOLID = 0x0;
	public static final int GDK_Linefeed = 0xff0A;
	public static final int GDK_LSB_FIRST = 0x0;
	public static final int GDK_Left = 0xff51;
	public static final int GDK_MOD1_MASK = 0x8;
	public static final int GDK_MOTION_NOTIFY = 0x3;
	public static final int GDK_NONE = 0;
	public static final int GDK_OVERLAP_RECTANGLE_OUT = 0x1;
	public static final int GDK_PIXBUF_ALPHA_BILEVEL = 0x0;
	public static final int GDK_POINTER_MOTION_HINT_MASK = 0x8;
	public static final int GDK_POINTER_MOTION_MASK = 0x4;
	public static final int GDK_Page_Down = 0xff56;
	public static final int GDK_Page_Up = 0xff55;
	public static final int GDK_Pause = 0xff13;
	public static final int GDK_QUESTION_ARROW = 0x5c;
	public static final int GDK_RGB_DITHER_NORMAL = 0x1;
	public static final int GDK_RIGHT_SIDE = 0x60;
	public static final int GDK_Return = 0xff0d;
	public static final int GDK_Right = 0xff53;
	public static final int GDK_space = 0x20;
	public static final int GDK_SB_H_DOUBLE_ARROW = 0x6c;
	public static final int GDK_SB_UP_ARROW = 0x72;
	public static final int GDK_SB_V_DOUBLE_ARROW = 0x74;
	public static final int GDK_SHIFT_MASK = 0x1;
	public static final int GDK_SIZING = 0x78;
	public static final int GDK_STIPPLED = 0x2;
	public static final int GDK_Shift_L = 0xffe1;
	public static final int GDK_Shift_R = 0xffe2;
	public static final int GDK_Scroll_Lock = 0xff14;
	public static final int GDK_TOP_LEFT_CORNER = 0x86;
	public static final int GDK_TOP_RIGHT_CORNER = 0x88;
	public static final int GDK_TOP_SIDE = 0x8a;
	public static final int GDK_Tab = 0xff09;
	public static final int GDK_Up = 0xff52;
	public static final int GDK_WATCH = 0x96;
	public static final int GDK_XOR = 0x2;
	public static final int GDK_XTERM = 0x98;
	public static final int GDK_X_CURSOR = 0x0;
	public static final int GTK_ACCEL_VISIBLE = 0x1;
	public static final int GTK_ARROW_DOWN = 0x1;
	public static final int GTK_ARROW_LEFT = 0x2;
	public static final int GTK_ARROW_RIGHT = 0x3;
	public static final int GTK_ARROW_UP = 0x0;
	public static final int GTK_CAN_DEFAULT = 0x2000;
	public static final int GTK_CAN_FOCUS = 0x800;
	public static final int GTK_CELL_RENDERER_MODE_ACTIVATABLE = 1;
	public static final int GTK_CLIST_SHOW_TITLES = 0x4;
	public static final int GTK_DIALOG_DESTROY_WITH_PARENT = 1 << 1;
	public static final int GTK_DIALOG_MODAL = 1 << 0;
	public static final int GTK_JUSTIFY_CENTER = 0x2;
	public static final int GTK_JUSTIFY_LEFT = 0x0;
	public static final int GTK_JUSTIFY_RIGHT = 0x1;
	public static final int GTK_MESSAGE_INFO = 0;
	public static final int GTK_MESSAGE_WARNING = 1;
	public static final int GTK_MESSAGE_QUESTION = 2;
	public static final int GTK_MESSAGE_ERROR = 3;
	public static final int GTK_ORIENTATION_HORIZONTAL = 0x0;
	public static final int GTK_ORIENTATION_VERTICAL = 0x1;
	public static final int GTK_POLICY_ALWAYS = 0x0;
	public static final int GTK_POLICY_AUTOMATIC = 0x1;
	public static final int GTK_POLICY_NEVER = 0x2;
	public static final int GTK_PROGRESS_CONTINUOUS = 0x0;
	public static final int GTK_PROGRESS_DISCRETE = 0x1;
	public static final int GTK_PROGRESS_LEFT_TO_RIGHT = 0x0;
	public static final int GTK_PROGRESS_TOP_TO_BOTTOM = 0x3;
	public static final int GTK_REALIZED  = 1 << 6;
	public static final int GTK_RELIEF_NONE = 0x2;
	public static final int GTK_RESPONSE_OK = 0xfffffffb;
	public static final int GTK_SELECTION_BROWSE = 0x2;
	public static final int GTK_SELECTION_MULTIPLE = 0x3;
	public static final int GTK_SENSITIVE = 0x200;
	public static final int GTK_SHADOW_ETCHED_IN = 0x3;
	public static final int GTK_SHADOW_ETCHED_OUT = 0x4;
	public static final int GTK_SHADOW_IN = 0x1;
	public static final int GTK_SHADOW_NONE = 0x0;
	public static final int GTK_SHADOW_OUT = 0x2;
	public static final int GTK_STATE_INSENSITIVE = 0x4;
	public static final int GTK_STATE_NORMAL = 0x0;
	public static final int GTK_TEXT_WINDOW_TEXT = 2;
	public static final int GTK_TOOLBAR_CHILD_BUTTON = 0x1;
	public static final int GTK_TOOLBAR_CHILD_RADIOBUTTON = 0x3;
	public static final int GTK_TOOLBAR_CHILD_TOGGLEBUTTON = 0x2;
	public static final int GTK_TREE_VIEW_COLUMN_GROW_ONLY = 0;
	public static final int GTK_TREE_VIEW_COLUMN_AUTOSIZE = 1;
	public static final int GTK_TREE_VIEW_COLUMN_FIXED = 2;
	public static final int GTK_TREE_VIEW_DROP_AFTER = 1;
	public static final int GTK_TREE_VIEW_DROP_BEFORE = 0;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_AFTER = 3;
	public static final int GTK_TREE_VIEW_DROP_INTO_OR_BEFORE = 2;
	public static final int GTK_VISIBILITY_FULL = 0x2;
	public static final int GTK_VISIBILITY_NONE = 0x0;
	public static final int GTK_VISIBLE = 0x100;
	public static final int GTK_WINDOW_POPUP = 0x1;
	public static final int GTK_WINDOW_TOPLEVEL = 0x0;
	public static final int GTK_WRAP_NONE = 0;
	public static final int GTK_WRAP_WORD = 2;
	public static final int G_LOG_FLAG_FATAL = 0x2;
	public static final int G_LOG_FLAG_RECURSION = 0x1;
	public static final int G_LOG_LEVEL_MASK = 0xfffffffc;
	public static final int None = 0;
	public static final int PANGO_SCALE = 1024;
	public static final int PANGO_STRETCH_NORMAL = 0x4;
	public static final int PANGO_STYLE_ITALIC = 0x2;
	public static final int PANGO_STYLE_NORMAL = 0x0;
	public static final int PANGO_STYLE_OBLIQUE = 0x1;
	public static final int PANGO_TAB_LEFT = 0;
	public static final int PANGO_WEIGHT_BOLD = 0x2bc;
	public static final int PANGO_WEIGHT_NORMAL = 0x190;
	
	/** Signals */
	public static final byte[] activate = signal("activate");
	public static final byte[] button_press_event = signal("button_press_event");
	public static final byte[] button_release_event = signal("button_release_event");
	public static final byte[] changed = signal("changed");
	public static final byte[] clicked = signal("clicked");
	public static final byte[] commit = signal("commit");
	public static final byte[] configure_event = signal("configure_event");
	public static final byte[] delete_event = signal("delete_event");
	public static final byte[] delete_range = signal("delete_range");
	public static final byte[] delete_text = signal("delete_text");
	public static final byte[] enter_notify_event = signal("enter_notify_event");
	public static final byte[] event = signal("event");
	public static final byte[] event_after = signal("event_after");
	public static final byte[] expose_event = signal("expose_event");
	public static final byte[] focus_in_event = signal("focus_in_event");
	public static final byte[] focus_out_event = signal("focus_out_event");
	public static final byte[] hide = signal("hide");
	public static final byte[] insert_text = signal("insert_text");
	public static final byte[] key_press_event = signal("key_press_event");
	public static final byte[] key_release_event = signal("key_release_event");
	public static final byte[] leave_notify_event = signal("leave_notify_event");
	public static final byte[] map_event = signal("map_event");
	public static final byte[] mnemonic_activate = signal("mnemonic_activate");
	public static final byte[] motion_notify_event = signal("motion_notify_event");
	public static final byte[] popup_menu = signal("popup_menu");
	public static final byte[] preedit_changed = signal("preedit_changed");
	public static final byte[] realize = signal("realize");
	public static final byte[] row_activated = signal("row_activated");
	public static final byte[] row_collapsed = signal("row_collapsed");
	public static final byte[] row_expanded = signal("row_expanded");
	public static final byte[] select = signal("select");
	public static final byte[] select_child = signal("select_child");
	public static final byte[] show = signal("show");
	public static final byte[] show_help = signal("show_help");
	public static final byte[] size_allocate = signal("size_allocate");
	public static final byte[] switch_page = signal("switch_page");
	public static final byte[] toggled = signal("toggled");
	public static final byte[] unmap_event = signal("unmap_event");
	public static final byte[] unrealize = signal("unrealize");
	public static final byte[] value_changed = signal("value_changed");
	
	/** Properties */
	public static final byte[] button_relief = signal("button_relief");
	public static final byte[] focus_line_width = signal("focus_line_width");
	public static final byte[] interior_focus = signal("interior_focus");
	public static final byte[] mode = signal("mode");
	
static byte [] signal (String name) {
	int length = name.length ();
	char [] chars = new char [length];
	name.getChars (0, length, chars, 0);
	byte [] buffer = new byte [length + 1];
	for (int i=0; i<length; i++) {
		buffer [i] = (byte) chars [i];
	}
	return buffer;
}

/** Object private fields accessors */
public static final synchronized native int GTK_WIDGET_HEIGHT(int widget);
public static final synchronized native int GTK_WIDGET_WIDTH(int widget);
public static final synchronized native int GTK_WIDGET_WINDOW(int widget);
public static final synchronized native int GTK_WIDGET_X(int widget);
public static final synchronized native int GTK_WIDGET_Y(int widget);
public static final synchronized native int GTK_SCROLLED_WINDOW_HSCROLLBAR(int widget);
public static final synchronized native int GTK_SCROLLED_WINDOW_VSCROLLBAR(int widget);
public static final synchronized native int GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(int widget);
public static final synchronized native void GTK_ACCEL_LABEL_ACCEL_STRING(int acce_label, int string);
public static final synchronized native int GTK_ACCEL_LABEL_ACCEL_STRING(int acce_label);
public static final synchronized native int GTK_ENTRY_IM_CONTEXT(int widget);
public static final synchronized native int GTK_TEXTVIEW_IM_CONTEXT(int widget);

/** Native methods */
public static final synchronized native int GDK_DISPLAY();
public static final synchronized native int GDK_ROOT_PARENT();
public static final synchronized native int GDK_TYPE_COLOR();
public static final synchronized native int GDK_TYPE_PIXBUF();
public static final synchronized native boolean GTK_IS_CELL_RENDERER_PIXBUF(int obj);
public static final synchronized native int GTK_WIDGET_FLAGS(int wid);
public static final synchronized native boolean GTK_WIDGET_HAS_DEFAULT(int wid);
public static final synchronized native boolean GTK_WIDGET_HAS_FOCUS(int wid);
public static final synchronized native boolean GTK_WIDGET_IS_SENSITIVE(int wid);
public static final synchronized native boolean GTK_WIDGET_MAPPED(int wid);
public static final synchronized native boolean GTK_WIDGET_SENSITIVE(int wid);
public static final synchronized native void GTK_WIDGET_SET_FLAGS(int wid, int flag);
public static final synchronized native void GTK_WIDGET_UNSET_FLAGS(int wid, int flag);
public static final synchronized native boolean GTK_WIDGET_VISIBLE(int wid);
public static final synchronized native int G_TYPE_BOOLEAN();
public static final synchronized native int G_TYPE_INT();
public static final synchronized native int G_TYPE_STRING();
public static final synchronized native int GtkTreeIter_sizeof();
public static final synchronized native int PANGO_PIXELS(int dimension);
public static final synchronized native int g_filename_to_utf8(int opsysstring, int len, int[] bytes_read, int[] bytes_written, int[] error);
public static final synchronized native int g_filename_from_utf8(int opsysstring, int len,  int[] bytes_read, int[] bytes_written, int[] error);
public static final synchronized native void g_free(int mem);
public static final synchronized native int g_list_append(int list, int data);
public static final synchronized native int g_list_data(int list);
public static final synchronized native void g_list_free(int list);
public static final synchronized native void g_list_free_1(int list);
public static final synchronized native int g_list_length(int list);
public static final synchronized native void g_list_next(int list, int llist);
public static final synchronized native int g_list_next(int list);
public static final synchronized native int g_list_nth(int list, int n);
public static final synchronized native int g_list_nth_data(int list, int n);
public static final synchronized native int g_list_prepend(int list, int data);
public static final synchronized native void g_list_previous(int list, int llist);
public static final synchronized native int g_list_previous(int list);
public static final synchronized native int g_list_remove_link(int list, int link);
public static final synchronized native int g_list_reverse(int list);
public static final synchronized native void g_log_default_handler(int log_domain, int log_levels, int message, int unused_data);
public static final synchronized native void g_log_remove_handler(byte[] log_domain, int handler_id);
public static final synchronized native int g_log_set_handler(byte[] log_domain, int log_levels, int log_func, int user_data);
public static final synchronized native int g_malloc(int size);
public static final synchronized native int g_object_get_qdata(int object, int quark);
public static final synchronized native int g_object_ref(int object);
public static final synchronized native void g_object_set(int object, byte[] first_property_name, int data);
public static final synchronized native void g_object_set_qdata(int object, int quark, int data);
public static final synchronized native void g_object_unref(int object);
public static final synchronized native int g_quark_from_string(byte[] string);
public static final synchronized native void g_signal_connect(int instance, byte[] detailed_signal, int proc, int data);
public static final synchronized native void g_signal_connect_after(int instance, byte[] detailed_signal, int proc, int data);
public static final synchronized native int g_signal_handlers_block_matched(int instance, int mask, int signal_id, int detail, int closure, int func, int data);
public static final synchronized native int g_signal_handlers_disconnect_matched(int instance, int mask, int signal_id, int detail, int closure, int func, int data);
public static final synchronized native int g_signal_handlers_unblock_matched(int instance, int mask, int signal_id, int detail, int closure, int func, int data);
public static final synchronized native void g_signal_stop_emission_by_name(int instance, byte[] detailed_signal);
public static final synchronized native void g_strfreev(int string_array);
public static final synchronized native void g_thread_init(int vtable);
public static final synchronized native boolean g_thread_supported();
public static final synchronized native int g_utf16_to_utf8(char[] str, int len, int[] items_read, int[] items_written, int[] error);
public static final synchronized native int g_utf8_to_utf16(byte[] str, int len, int[] items_read, int[] items_written, int[] error);
public static final synchronized native int g_utf8_to_utf16(int str, int len, int[] items_read, int[] items_written, int[] error);
public static final synchronized native int gdk_atom_intern(byte[] atom_name, boolean only_if_exists);
public static final synchronized native int gdk_atom_name(int atom);
public static final synchronized native void gdk_beep();
public static final synchronized native int gdk_bitmap_create_from_data(int window, byte[] data, int width, int height);
public static final synchronized native boolean gdk_color_white(int colormap, GdkColor color);
public static final synchronized native boolean gdk_colormap_alloc_color(int colormap, GdkColor color, boolean writeable, boolean best_match);
public static final synchronized native void gdk_colormap_free_colors(int colormap, GdkColor colors, int ncolors);
public static final synchronized native int gdk_colormap_get_system();
public static final synchronized native void gdk_colormap_query_color(int colormap, int pixel, GdkColor result);
public static final synchronized native void gdk_cursor_destroy(int cursor);
public static final synchronized native int gdk_cursor_new(int cursor_type);
public static final synchronized native int gdk_cursor_new_from_pixmap(int source, int mask, GdkColor fg, GdkColor bg, int x, int y);
public static final synchronized native void gdk_drag_status(int context, int action, int time);
public static final synchronized native void gdk_draw_arc(int drawable, int gc, int filled, int x, int y, int width, int height, int angle1, int angle2);
public static final synchronized native void gdk_draw_drawable(int drawable, int gc, int src, int xsrc, int ysrc, int xdest, int ydest, int width, int height);
public static final synchronized native void gdk_draw_layout(int drawable, int gc, int x, int y, int layout);
public static final synchronized native void gdk_draw_line(int drawable, int gc, int x1, int y1, int x2, int y2);
public static final synchronized native void gdk_draw_lines(int drawable, int gc, int[] points, int npoints);
public static final synchronized native void gdk_draw_polygon(int drawable, int gc, int filled, int[] points, int npoints);
public static final synchronized native void gdk_draw_rectangle(int drawable, int gc, int filled, int x, int y, int width, int height);
public static final synchronized native int gdk_drawable_get_image(int drawable, int x, int y, int width, int height);
public static final synchronized native void gdk_drawable_get_size(int drawable, int[] width, int[] height);
public static final synchronized native int gdk_drawable_get_visible_region(int drawable);
public static final synchronized native int gdk_event_copy(int event);
public static final synchronized native void gdk_event_free(int event);
public static final synchronized native int gdk_event_get();
public static final synchronized native boolean gdk_event_get_coords(int event, double[] px, double[] py);
public static final synchronized native boolean gdk_event_get_state(int event, int[] pmod);
public static final synchronized native int gdk_event_get_time(int event);
public static final synchronized native void gdk_event_handler_set(int func, int data, int notify);
public static final synchronized native void gdk_flush();
public static final synchronized native void gdk_free_text_list(int list);
public static final synchronized native void gdk_gc_get_values(int gc, GdkGCValues values);
public static final synchronized native int gdk_gc_new(int window);
public static final synchronized native void gdk_gc_set_background(int gc, GdkColor color);
public static final synchronized native void gdk_gc_set_clip_mask(int gc, int mask);
public static final synchronized native void gdk_gc_set_clip_origin(int gc, int x, int y);
public static final synchronized native void gdk_gc_set_clip_rectangle(int gc, GdkRectangle rectangle);
public static final synchronized native void gdk_gc_set_clip_region(int gc, int region);
public static final synchronized native void gdk_gc_set_dashes(int gc, int dash_offset, byte[] dash_list, int n);
public static final synchronized native void gdk_gc_set_exposures(int gc, boolean exposures);
public static final synchronized native void gdk_gc_set_fill(int gc, int fill);
public static final synchronized native void gdk_gc_set_foreground(int gc, GdkColor color);
public static final synchronized native void gdk_gc_set_function(int gc, int function);
public static final synchronized native void gdk_gc_set_line_attributes(int gc, int line_width, int line_style, int cap_style, int join_style);
public static final synchronized native void gdk_gc_set_stipple(int gc, int stipple);
public static final synchronized native void gdk_gc_set_subwindow(int gc, int mode);
public static final synchronized native void gdk_gc_set_values(int gc, GdkGCValues values, int values_mask);
public static final synchronized native int gdk_image_get(int window, int x, int y, int width, int height);
public static final synchronized native int gdk_image_get_pixel(int image, int x, int y);
public static final synchronized native void gdk_keyboard_ungrab(int time);
public static final synchronized native int gdk_keyval_to_unicode(int keyval);
public static final synchronized native int gdk_pango_context_get();
public static final synchronized native int gdk_pixbuf_get_from_drawable(int dest, int src, int cmap, int src_x, int src_y, int dest_x, int dest_y, int width, int height);
public static final synchronized native int gdk_pixbuf_get_pixels(int pixbuf);
public static final synchronized native int gdk_pixbuf_get_rowstride(int pixbuf);
public static final synchronized native int gdk_pixbuf_new(int colorspace, boolean has_alpha, int bits_per_sample, int width, int height);
public static final synchronized native void gdk_pixbuf_render_to_drawable(int pixbuf, int drawable, int gc, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int dither, int x_dither, int y_dither);
public static final synchronized native void gdk_pixbuf_render_to_drawable_alpha(int pixbuf, int drawable, int src_x, int src_y, int dest_x, int dest_y, int width, int height, int alpha_mode, int alpha_threshold, int dither, int x_dither, int y_dither);
public static final synchronized native void gdk_pixbuf_scale(int src, int dest, int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, int interp_type);
public static final synchronized native int gdk_pixbuf_scale_simple(int src, int dest_width, int dest_height, int interp_type);
public static final synchronized native int gdk_pixmap_new(int window, int width, int height, int depth);
public static final synchronized native int gdk_pointer_grab(int window, boolean owner_events, int event_mask, int confine_to, int cursor, int time);
public static final synchronized native boolean gdk_pointer_is_grabbed();
public static final synchronized native void gdk_pointer_ungrab(int time);
public static final synchronized native void gdk_region_destroy(int region);
public static final synchronized native boolean gdk_region_empty(int region);
public static final synchronized native void gdk_region_get_clipbox(int region, GdkRectangle rectangle);
public static final synchronized native void gdk_region_get_rectangles(int region, int[] rectangles, int[] n_rectangles);
public static final synchronized native void gdk_region_intersect(int source1, int source2);
public static final synchronized native int gdk_region_new();
public static final synchronized native void gdk_region_offset(int region, int dx, int dy);
public static final synchronized native boolean gdk_region_point_in(int region, int x, int y);
public static final synchronized native int gdk_region_rect_in(int region, GdkRectangle rect);
public static final synchronized native void gdk_region_subtract(int source1, int source2);
public static final synchronized native void gdk_region_union(int source1, int source2);
public static final synchronized native void gdk_region_union_with_rect(int region, GdkRectangle rect);
public static final synchronized native void gdk_rgb_init();
public static final synchronized native int gdk_screen_height();
public static final synchronized native int gdk_screen_width();
public static final synchronized native int gdk_screen_width_mm();
public static final synchronized native void gdk_set_program_class(byte[] program_class);
public static final synchronized native boolean gdk_utf8_to_compound_text(byte[] str, int[] encoding, int[] format, int[] ctext, int[] length);
public static final synchronized native int gdk_text_property_to_utf8_list  (int encoding, int format, int text, int length,  int[] list);
public static final synchronized native void gdk_threads_enter();
public static final synchronized native void gdk_threads_init();
public static final synchronized native void gdk_threads_leave();
public static final synchronized native int gdk_visual_get_system();
public static final synchronized native int gdk_window_at_pointer(int[] win_x, int[] win_y);
public static final synchronized native void gdk_window_get_frame_extents(int window, GdkRectangle rect);
public static final synchronized native int gdk_window_get_origin(int window, int[] x, int[] y);
public static final synchronized native int gdk_window_get_parent(int window);
public static final synchronized native int gdk_window_get_pointer(int window, int[] x, int[] y, int[] mask);
public static final synchronized native void gdk_window_get_user_data(int window, int[] data);
public static final synchronized native void gdk_window_invalidate_rect(int window, GdkRectangle rectangle, boolean invalidate_children);
public static final synchronized native void gdk_window_invalidate_region(int window, int region, boolean invalidate_children);
public static final synchronized native void gdk_window_lower(int window);
public static final synchronized native void gdk_window_process_updates(int window, boolean update_children);
public static final synchronized native void gdk_window_raise(int window);
public static final synchronized native void gdk_window_set_back_pixmap(int window, int pixmap, boolean parent_relative);
public static final synchronized native void gdk_window_set_cursor(int window, int cursor);
public static final synchronized native void gdk_window_set_decorations(int window, int decorations);
public static final synchronized native void gdk_window_set_icon(int window, int icon_window, int pixmap, int mask);
public static final synchronized native void gdk_window_set_override_redirect(int window, boolean override_redirect);
public static final synchronized native void gdk_window_show(int window);
public static final synchronized native int gtk_accel_group_new();
public static final synchronized native boolean gtk_accel_groups_activate(int accelGroup, int accelKey, int accelMods);
public static final synchronized native void gtk_accel_label_set_accel_widget(int accel_label, int accel_widget);
public static final synchronized native void gtk_adjustment_changed(int adjustment);
public static final synchronized native int gtk_adjustment_new(double value, double lower, double upper, double step_increment, double page_increment, double page_size);
public static final synchronized native void gtk_adjustment_set_value(int adjustment, double value);
public static final synchronized native void gtk_adjustment_value_changed(int adjustment);
public static final synchronized native int gtk_arrow_new(int arrow_type, int shadow_type);
public static final synchronized native void gtk_arrow_set(int arrow, int arrow_type, int shadow_type);
public static final synchronized native int gtk_bin_get_child(int bin);
public static final synchronized native int gtk_button_new();
public static final synchronized native void gtk_button_set_relief(int button, int newstyle);
public static final synchronized native void gtk_cell_renderer_get_size(int cell, int widget, GdkRectangle area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final synchronized native int gtk_cell_renderer_pixbuf_new();
public static final synchronized native int gtk_cell_renderer_text_new();
public static final synchronized native int gtk_cell_renderer_toggle_new();
public static final synchronized native int gtk_check_button_new();
public static final synchronized native boolean gtk_check_menu_item_get_active(int wid);
public static final synchronized native int gtk_check_menu_item_new_with_label(byte[] label);
public static final synchronized native void gtk_check_menu_item_set_active(int wid, boolean active);
public static final synchronized native int gtk_check_version(int required_major, int required_minor, int required_micro);
public static final synchronized native void gtk_clipboard_clear(int clipboard);
public static final synchronized native int gtk_clipboard_get(int selection);
public static final synchronized native boolean gtk_clipboard_set_with_data(int clipboard, int target, int n_targets, int get_func, int clear_func, int user_data);
public static final synchronized native int gtk_clipboard_wait_for_contents(int clipboard, int target);
public static final synchronized native int gtk_color_selection_dialog_new(byte[] title);
public static final synchronized native void gtk_color_selection_get_current_color(int colorsel, GdkColor color);
public static final synchronized native void gtk_color_selection_set_current_color(int colorsel, GdkColor color);
public static final synchronized native void gtk_combo_disable_activate(int combo);
public static final synchronized native int gtk_combo_new();
public static final synchronized native void gtk_combo_set_case_sensitive(int combo, boolean val);
public static final synchronized native void gtk_combo_set_popdown_strings(int combo, int strings);
public static final synchronized native void gtk_container_add(int container, int widget);
public static final synchronized native int gtk_container_get_border_width(int container);
public static final synchronized native int gtk_container_get_children(int container);
public static final synchronized native void gtk_container_remove(int container, int widget);
public static final synchronized native void gtk_container_resize_children(int container);
public static final synchronized native void gtk_container_set_border_width(int container, int border_width);
public static final synchronized native int gtk_dialog_add_button(int dialog, String button_text, int response_id);
public static final synchronized native int gtk_dialog_run(int dialog);
public static final synchronized native int gtk_drag_begin(int widget, int targets, int actions, int button, int event);
public static final synchronized native boolean gtk_drag_check_threshold(int widget, int start_x, int start_y, int current_x, int current_y);
public static final synchronized native int gtk_drag_dest_find_target(int widget, int context, int target_list);
public static final synchronized native void gtk_drag_dest_set(int widget, int flags, int targets, int n_targets, int actions);
public static final synchronized native void gtk_drag_dest_unset(int widget);
public static final synchronized native void gtk_drag_finish(int context, boolean success, boolean delete, int time);
public static final synchronized native void gtk_drag_get_data(int widget, int context, int target, int time);
public static final synchronized native int gtk_drawing_area_new();
public static final synchronized native void gtk_editable_copy_clipboard(int editable);
public static final synchronized native void gtk_editable_cut_clipboard(int editable);
public static final synchronized native void gtk_editable_delete_selection(int editable);
public static final synchronized native void gtk_editable_delete_text(int editable, int start_pos, int end_pos);
public static final synchronized native int gtk_editable_get_chars(int editable, int start_pos, int end_pos);
public static final synchronized native boolean gtk_editable_get_editable(int editable);
public static final synchronized native int gtk_editable_get_position(int editable);
public static final synchronized native boolean gtk_editable_get_selection_bounds(int editable, int[] start, int[] end);
public static final synchronized native void gtk_editable_insert_text(int editable, byte[] new_text, int new_text_length, int[] position);
public static final synchronized native void gtk_editable_paste_clipboard(int editable);
public static final synchronized native void gtk_editable_select_region(int editable, int start, int end);
public static final synchronized native void gtk_editable_set_editable(int entry, boolean editable);
public static final synchronized native void gtk_editable_set_position(int editable, int position);
public static final synchronized native char gtk_entry_get_invisible_char(int entry);
public static final synchronized native int gtk_entry_get_layout (int entry);
public static final synchronized native int gtk_entry_get_max_length(int entry);
public static final synchronized native int gtk_entry_get_text(int entry);
public static final synchronized native boolean gtk_entry_get_visibility(int entry);
public static final synchronized native int gtk_entry_new();
public static final synchronized native void gtk_entry_set_activates_default(int entry, boolean setting);
public static final synchronized native void gtk_entry_set_has_frame(int entry, boolean setting);
public static final synchronized native void gtk_entry_set_invisible_char(int entry, char ch);
public static final synchronized native void gtk_entry_set_max_length(int entry, int max);
public static final synchronized native void gtk_entry_set_text(int entry, byte[] text);
public static final synchronized native void gtk_entry_set_visibility(int entry, boolean visible);
public static final synchronized native int gtk_events_pending();
public static final synchronized native void gtk_file_selection_complete(int filesel, byte[] pattern);
public static final synchronized native int gtk_file_selection_get_filename(int filesel);
public static final synchronized native int gtk_file_selection_get_selections(int filesel);
public static final synchronized native int gtk_file_selection_hide_fileop_buttons(int filesel);
public static final synchronized native int gtk_file_selection_new(byte[] title);
public static final synchronized native void gtk_file_selection_set_filename(int filesel, int filename);
public static final synchronized native void gtk_file_selection_set_select_multiple(int filesel, boolean select_multiple);
public static final synchronized native void gtk_fixed_move(int fixed, int widget, int x, int y);
public static final synchronized native int gtk_fixed_new();
public static final synchronized native void gtk_fixed_set_has_window(int fixed, boolean has_window);
public static final synchronized native int gtk_font_selection_dialog_get_font_name(int fsd);
public static final synchronized native int gtk_font_selection_dialog_new(byte[] title);
public static final synchronized native boolean gtk_font_selection_dialog_set_font_name(int fsd, byte[] fontname);
public static final synchronized native int gtk_frame_new(byte[] label);
public static final synchronized native void gtk_frame_set_label(int frame, byte[] label);
public static final synchronized native void gtk_frame_set_label_widget(int frame, int label_widget);
public static final synchronized native void gtk_frame_set_shadow_type(int frame, int type);
public static final synchronized native int gtk_get_current_event();
public static final synchronized native int gtk_get_current_event_time();
public static final synchronized native int gtk_get_default_language();
public static final synchronized native int gtk_grab_get_current();
public static final synchronized native void gtk_grab_remove(int widget);
public static final synchronized native int gtk_hbox_new(boolean homogeneous, int spacing);
public static final synchronized native int gtk_hscale_new(int adjustment);
public static final synchronized native int gtk_hscrollbar_new(int adjustment);
public static final synchronized native int gtk_hseparator_new();
public static final synchronized native boolean gtk_im_context_filter_keypress(int context, int event);
public static final synchronized native void gtk_im_context_focus_in(int context);
public static final synchronized native void gtk_im_context_focus_out(int context);
public static final synchronized native void gtk_im_context_get_preedit_string(int context, int[] str, int[] attrs, int[] cursor_pos);
public static final synchronized native void gtk_im_context_reset(int context);
public static final synchronized native void gtk_im_context_set_client_window(int context, int window);
public static final synchronized native void gtk_im_context_set_cursor_location(int context, GdkRectangle area);
public static final synchronized native void gtk_im_multicontext_append_menuitems (int context, int menushell);
public static final synchronized native int gtk_im_multicontext_new();
public static final synchronized native int gtk_image_menu_item_new_with_label(byte[] label);
public static final synchronized native void gtk_image_menu_item_set_image(int menu_item, int image);
public static final synchronized native int gtk_image_new();
public static final synchronized native int gtk_image_new_from_pixmap(int pixmap, int mask);
public static final synchronized native void gtk_image_set_from_pixmap(int image, int pixmap, int mask);
public static final synchronized native boolean gtk_init_check(int[] argc, int[] argv);
public static final synchronized native int gtk_label_new(byte[] label);
public static final synchronized native int gtk_label_new_with_mnemonic(byte[] str);
public static final synchronized native void gtk_label_set_attributes(int label, int attrs);
public static final synchronized native void gtk_label_set_justify(int label, int jtype);
public static final synchronized native void gtk_label_set_line_wrap(int label, boolean wrap);
public static final synchronized native void gtk_label_set_text(int label, int str);
public static final synchronized native void gtk_label_set_text_with_mnemonic(int label, byte[] str);
public static final synchronized native void gtk_list_store_append(int list_store, int iter);
public static final synchronized native void gtk_list_store_clear(int store);
public static final synchronized native void gtk_list_store_insert(int list_store, int iter, int position);
public static final synchronized native int gtk_list_store_newv(int numColumns, int[] types);
public static final synchronized native void gtk_list_store_remove(int list_store, int iter);
public static final synchronized native void gtk_list_store_set(int store, int iter, int column, byte[] value, int terminator);
public static final synchronized native void gtk_list_store_set(int store, int iter, int column, int value, int terminator);
public static final synchronized native void gtk_list_store_set(int store, int iter, int column, GdkColor value, int terminator);
public static final synchronized native void gtk_list_store_set(int store, int iter, int column, boolean value, int terminator);
public static final synchronized native int gtk_major_version();
public static final synchronized native int gtk_minor_version();
public static final synchronized native int gtk_micro_version();
public static final synchronized native void gtk_main();
public static final synchronized native int gtk_main_iteration();
public static final synchronized native void gtk_main_do_event(int event);
public static final synchronized native int gtk_menu_bar_new();
public static final synchronized native void gtk_menu_item_remove_submenu(int menu_item);
public static final synchronized native void gtk_menu_item_set_submenu(int menu_item, int submenu);
public static final synchronized native int gtk_menu_new();
public static final synchronized native void gtk_menu_popdown(int menu);
public static final synchronized native void gtk_menu_popup(int menu, int parent_menu_shell, int parent_menu_item, int func, int data, int button, int activate_time);
public static final synchronized native void gtk_menu_shell_deactivate(int menu_shell);
public static final synchronized native void gtk_menu_shell_insert(int menu_shell, int child, int position);
public static final synchronized native void gtk_menu_shell_select_item(int menu_shell, int menu_item);
public static final synchronized native int gtk_message_dialog_new(int parent, int flags, int type, int buttons, String message_format);
public static final synchronized native void gtk_misc_set_alignment(int misc, float xalign, float yalign);
public static final synchronized native int gtk_notebook_get_current_page(int notebook);
public static final synchronized native boolean gtk_notebook_get_scrollable(int notebook);
public static final synchronized native void gtk_notebook_insert_page(int notebook, int child, int tab_label, int position);
public static final synchronized native int gtk_notebook_new();
public static final synchronized native void gtk_notebook_remove_page(int notebook, int page_num);
public static final synchronized native void gtk_notebook_set_current_page(int notebook, int page_num);
public static final synchronized native void gtk_notebook_set_scrollable(int notebook, boolean scrollable);
public static final synchronized native void gtk_notebook_set_show_tabs(int notebook, boolean show_tabs);
public static final synchronized native void gtk_object_sink(int object);
public static final synchronized native int gtk_progress_bar_new();
public static final synchronized native void gtk_progress_bar_pulse(int pbar);
public static final synchronized native void gtk_progress_bar_set_bar_style(int pbar, int style);
public static final synchronized native void gtk_progress_bar_set_fraction(int pbar, double fraction);
public static final synchronized native void gtk_progress_bar_set_orientation(int pbar, int orientation);
public static final synchronized native int gtk_radio_button_get_group(int radio_button);
public static final synchronized native int gtk_radio_button_new(int group);
public static final synchronized native int gtk_radio_menu_item_new_with_label(int group, byte[] label);
public static final synchronized native int gtk_range_get_adjustment(int range);
public static final synchronized native int gtk_range_set_increments(int range, double step, double page);
public static final synchronized native int gtk_range_set_range(int range, double min, double max);
public static final synchronized native int gtk_range_set_value(int range, double value);
public static final synchronized native void gtk_rc_style_set_xthickness(int style, int thickness);
public static final synchronized native void gtk_rc_style_set_ythickness(int style, int thickness);
public static final synchronized native void gtk_scale_set_digits(int scale, int digits);
public static final synchronized native void gtk_scale_set_draw_value(int scale, boolean draw_value);
public static final synchronized native int gtk_scrolled_window_get_hadjustment(int scrolled_window);
public static final synchronized native void gtk_scrolled_window_get_policy(int scrolled_window, int[] hscrollbar_policy, int[] vscrollbar_policy);
public static final synchronized native int gtk_scrolled_window_get_shadow_type(int scrolled_window);
public static final synchronized native int gtk_scrolled_window_get_vadjustment(int scrolled_window);
public static final synchronized native int gtk_scrolled_window_new(int hadjustment, int vadjustment);
public static final synchronized native void gtk_scrolled_window_set_policy(int scrolled_window, int hscrollbar_policy, int vscrollbar_policy);
public static final synchronized native void gtk_scrolled_window_set_shadow_type(int scrolled_window, int type);
public static final synchronized native void gtk_selection_data_free(int selection_data);
public static final synchronized native void gtk_selection_data_set(int selection_data, int type, int format, int data, int length);
public static final synchronized native int gtk_separator_menu_item_new();
public static final synchronized native int gtk_set_locale();
public static final synchronized native int gtk_target_list_new(int targets, int ntargets);
public static final synchronized native void gtk_target_list_unref(int list);
public static final synchronized native void gtk_text_buffer_copy_clipboard(int buffer, int clipboard);
public static final synchronized native void gtk_text_buffer_cut_clipboard(int buffer, int clipboard, boolean default_editable);
public static final synchronized native void gtk_text_buffer_delete(int buffer, byte[] start, byte[] end);
public static final synchronized native void gtk_text_buffer_get_bounds(int buffer, byte[] start, byte[] end);
public static final synchronized native int gtk_text_buffer_get_char_count(int buffer);
public static final synchronized native void gtk_text_buffer_get_end_iter(int buffer, byte[] iter);
public static final synchronized native int gtk_text_buffer_get_insert(int buffer);
public static final synchronized native void gtk_text_buffer_get_iter_at_line(int buffer, byte[] iter, int line_number);
public static final synchronized native void gtk_text_buffer_get_iter_at_mark(int buffer, byte[] iter, int mark);
public static final synchronized native void gtk_text_buffer_get_iter_at_offset(int buffer, byte[] iter, int char_offset);
public static final synchronized native int gtk_text_buffer_get_line_count(int buffer);
public static final synchronized native int gtk_text_buffer_get_selection_bound(int buffer);
public static final synchronized native boolean gtk_text_buffer_get_selection_bounds(int buffer, byte[] start, byte[] end);
public static final synchronized native int gtk_text_buffer_get_text(int buffer, byte[] start, byte[] end, boolean include_hidden_chars);
public static final synchronized native void gtk_text_buffer_insert(int buffer, byte[] iter, byte[] text, int len);
public static final synchronized native void gtk_text_buffer_move_mark(int buffer, int mark, byte[] where);
public static final synchronized native void gtk_text_buffer_paste_clipboard(int buffer, int clipboard, byte[] override_location, boolean default_editable);
public static final synchronized native void gtk_text_buffer_place_cursor(int buffer, byte[] where);
public static final synchronized native void gtk_text_buffer_set_text(int buffer, byte[] text, int len);
public static final synchronized native int gtk_text_iter_get_line(byte[] iter);
public static final synchronized native int gtk_text_iter_get_offset(byte[] iter);
public static final synchronized native void gtk_text_view_buffer_to_window_coords(int text_view, int win, int buffer_x, int buffer_y, int[] window_x, int[] window_y);
public static final synchronized native int gtk_text_view_get_buffer(int text_view);
public static final synchronized native boolean gtk_text_view_get_editable(int text_view);
public static final synchronized native void gtk_text_view_get_iter_location(int text_view, byte[] iter, GdkRectangle location);
public static final synchronized native void gtk_text_view_get_line_at_y(int text_view, byte[] target_iter, int y, int[] line_top);
public static final synchronized native void gtk_text_view_get_visible_rect(int text_view, GdkRectangle visible_rect);
public static final synchronized native int gtk_text_view_get_window(int text_view, int win);
public static final synchronized native int gtk_text_view_new();
public static final synchronized native void gtk_text_view_scroll_mark_onscreen(int text_view, int mark);
public static final synchronized native boolean gtk_text_view_scroll_to_iter(int text_view, byte[] iter, double within_margin, boolean use_align, double xalign, double yalign);
public static final synchronized native void gtk_text_view_set_editable(int text_view, boolean setting);
public static final synchronized native void gtk_text_view_set_tabs(int text_view, int tabs);
public static final synchronized native void gtk_text_view_set_wrap_mode(int text_view, int wrap_mode);
public static final synchronized native int gtk_timeout_add(int interval, int function, int data);
public static final synchronized native void gtk_timeout_remove(int timeout_handler_id);
public static final synchronized native boolean gtk_toggle_button_get_active(int toggle_button);
public static final synchronized native int gtk_toggle_button_new();
public static final synchronized native void gtk_toggle_button_set_active(int toggle_button, boolean is_active);
public static final synchronized native void gtk_toggle_button_set_mode(int toggle_button, boolean draw_indicator);
public static final synchronized native void gtk_toolbar_insert_widget(int toolbar, int widget, byte[] tooltip_text, byte[] tooltip_private_text, int position);
public static final synchronized native int gtk_toolbar_new();
public static final synchronized native void gtk_toolbar_set_orientation(int toolbar, int orientation);
public static final synchronized native void gtk_tooltips_disable(int tooltips);
public static final synchronized native void gtk_tooltips_enable(int tooltips);
public static final synchronized native int gtk_tooltips_new();
public static final synchronized native void gtk_tooltips_set_tip(int tooltips, int widget, byte[] tip_text, byte[] tip_private);
public static final synchronized native void gtk_tree_model_get(int tree_model, int iter, int column, int[] ptr, int terminator);
public static final synchronized native boolean gtk_tree_model_get_iter(int tree_model, int iter, int path);
public static final synchronized native boolean gtk_tree_model_get_iter_first(int tree_model, int iter);
public static final synchronized native int gtk_tree_model_get_n_columns(int tree_model);
public static final synchronized native int gtk_tree_model_get_path(int tree_model, int iter);
public static final synchronized native boolean gtk_tree_model_iter_children(int model, int iter, int parent);
public static final synchronized native int gtk_tree_model_iter_n_children(int model, int iter);
public static final synchronized native boolean gtk_tree_model_iter_next(int model, int iter);
public static final synchronized native boolean gtk_tree_model_iter_nth_child(int tree_model, int iter, int parent, int n);
public static final synchronized native void gtk_tree_path_append_index(int path, int index);
public static final synchronized native void gtk_tree_path_free(int path);
public static final synchronized native int gtk_tree_path_get_depth(int path);
public static final synchronized native int gtk_tree_path_get_indices(int path);
public static final synchronized native int gtk_tree_path_new();
public static final synchronized native int gtk_tree_path_new_first();
public static final synchronized native int gtk_tree_path_new_from_string(byte[] path);
public static final synchronized native int gtk_tree_path_new_from_string(int path);
public static final synchronized native boolean gtk_tree_path_up(int path);
public static final synchronized native boolean gtk_tree_selection_get_selected(int selection, int[] model, int iter);
public static final synchronized native boolean gtk_tree_selection_path_is_selected(int selection, int path);
public static final synchronized native void gtk_tree_selection_select_all(int selection);
public static final synchronized native void gtk_tree_selection_select_iter(int selection, int iter);
public static final synchronized native void gtk_tree_selection_selected_foreach(int selection, int func, int data);
public static final synchronized native void gtk_tree_selection_set_mode(int selection, int mode);
public static final synchronized native void gtk_tree_selection_unselect_all(int selection);
public static final synchronized native void gtk_tree_selection_unselect_iter(int selection, int iter);
public static final synchronized native void gtk_tree_store_append(int store, int iter, int parent);
public static final synchronized native void gtk_tree_store_clear(int store);
public static final synchronized native void gtk_tree_store_insert(int store, int iter, int parent, int position);
public static final synchronized native int gtk_tree_store_newv(int numColumns, int[] types);
public static final synchronized native void gtk_tree_store_remove(int store, int iter);
public static final synchronized native void gtk_tree_store_set(int store, int iter, int column, byte[] value, int terminator);
public static final synchronized native void gtk_tree_store_set(int store, int iter, int column, int value, int terminator);
public static final synchronized native void gtk_tree_store_set(int store, int iter, int column, GdkColor value, int terminator);
public static final synchronized native void gtk_tree_store_set(int store, int iter, int column, boolean value, int terminator);
public static final synchronized native boolean gtk_tree_view_collapse_row(int view, int path);
public static final synchronized native void gtk_tree_view_column_add_attribute(int treeColumn, int cellRenderer, String attribute, int column);
public static final synchronized native void gtk_tree_view_column_clear(int tree_column);
public static final synchronized native void gtk_tree_view_column_cell_get_size(int tree_column, GdkRectangle cell_area, int[] x_offset, int[] y_offset, int[] width, int[] height);
public static final synchronized native void gtk_tree_view_column_cell_set_cell_data(int tree_column, int tree_model, int iter, boolean is_expander, boolean is_expanded);
public static final synchronized native int gtk_tree_view_column_get_cell_renderers(int tree_column);
public static final synchronized native boolean gtk_tree_view_column_get_resizable(int column);
public static final synchronized native int gtk_tree_view_column_get_spacing(int tree_column);
public static final synchronized native int gtk_tree_view_column_get_width(int column);
public static final synchronized native int gtk_tree_view_column_new();
public static final synchronized native void gtk_tree_view_column_pack_start(int tree_column, int cell_renderer, boolean expand);
public static final synchronized native void gtk_tree_view_column_set_clickable(int column, boolean clickable);
public static final synchronized native void gtk_tree_view_column_set_fixed_width(int column, int fixed_width);
public static final synchronized native void gtk_tree_view_column_set_resizable(int column, boolean resizable);
public static final synchronized native void gtk_tree_view_column_set_sizing(int column, int type);
public static final synchronized native void gtk_tree_view_column_set_title(int tree_column, byte[] title);
public static final synchronized native void gtk_tree_view_column_set_widget(int tree_column, int widget);
public static final synchronized native void gtk_tree_view_set_drag_dest_row(int view, int path, int pos);
public static final synchronized native boolean gtk_tree_view_expand_row(int view, int path, boolean open_all);
public static final synchronized native int gtk_tree_view_get_bin_window(int tree_view);
public static final synchronized native void gtk_tree_view_get_cell_area(int tree_view, int path, int column, GdkRectangle rect);
public static final synchronized native int gtk_tree_view_get_column(int tree_view, int n);
public static final synchronized native void gtk_tree_view_get_cursor(int tree_view, int[] path, int[] focus_column);
public static final synchronized native boolean gtk_tree_view_get_headers_visible(int tree_view);
public static final synchronized native boolean gtk_tree_view_get_path_at_pos(int tree_view, int x, int y, int[] path, int[] column, int[] cell_x, int[] cell_y);
public static final synchronized native boolean gtk_tree_view_get_rules_hint(int tree_view);
public static final synchronized native int gtk_tree_view_get_selection(int tree_view);
public static final synchronized native void gtk_tree_view_get_visible_rect(int tree_view, GdkRectangle visible_rect);
public static final synchronized native int gtk_tree_view_insert_column(int tree_view, int column, int position);
public static final synchronized native int gtk_tree_view_new_with_model(int model);
public static final synchronized native void gtk_tree_view_remove_column(int tree_view, int column);
public static final synchronized native boolean gtk_tree_view_row_expanded(int view, int path);
public static final synchronized native void gtk_tree_view_scroll_to_cell(int tree_view, int path, int column, boolean use_align, float row_aligh, float column_align);
public static final synchronized native void gtk_tree_view_set_cursor(int tree_view, int path, int focus_column, boolean start_editing); 
public static final synchronized native void gtk_tree_view_set_headers_visible(int tree_view, boolean visible);
public static final synchronized native void gtk_tree_view_set_model(int tree_view, int model);
public static final synchronized native void gtk_tree_view_set_rules_hint(int tree_view, boolean setting);
public static final synchronized native void gtk_tree_view_unset_rows_drag_dest(int tree_view);
public static final synchronized native void gtk_tree_view_widget_to_tree_coords(int tree_view, int wx, int wy, int[] tx, int[] ty);
public static final synchronized native int gtk_vbox_new(boolean homogeneous, int spacing);
public static final synchronized native int gtk_vscale_new(int adjustment);
public static final synchronized native int gtk_vscrollbar_new(int adjustment);
public static final synchronized native int gtk_vseparator_new();
public static final synchronized native void gtk_widget_add_accelerator(int widget, byte[] accel_signal, int accel_group, int accel_key, int accel_mods, int accel_flags);
public static final synchronized native void gtk_widget_add_events(int widget, int events);
public static final synchronized native int gtk_widget_create_pango_layout(int widget, byte[] text);
public static final synchronized native int gtk_widget_create_pango_layout(int widget, int text);
public static final synchronized native void gtk_widget_destroy(int widget);
public static final synchronized native int gtk_widget_get_default_style();
public static final synchronized native int gtk_widget_get_modifier_style(int widget);
public static final synchronized native int gtk_widget_get_pango_context(int widget);
public static final synchronized native int gtk_widget_get_parent(int widget);
public static final synchronized native int gtk_widget_get_style(int widget);
public static final synchronized native void gtk_widget_grab_focus(int widget);
public static final synchronized native void gtk_widget_hide(int widget);
public static final synchronized native boolean gtk_widget_is_focus(int widget);
public static final synchronized native void gtk_widget_modify_base(int widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_bg(int widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_fg(int widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_modify_font(int widget, int pango_font_descr);
public static final synchronized native void gtk_widget_modify_style(int widget, int style);
public static final synchronized native void gtk_widget_modify_text(int widget, int state, GdkColor color);
public static final synchronized native void gtk_widget_realize(int widget);
public static final synchronized native void gtk_widget_remove_accelerator(int widget, int accel_group, int accel_key, int accel_mods);
public static final synchronized native void gtk_widget_reparent(int widget, int new_parent);
public static final synchronized native void gtk_widget_set_double_buffered(int widget, boolean double_buffered);
public static final synchronized native void gtk_widget_set_name(int widget, byte[] name);
public static final synchronized native void gtk_widget_set_redraw_on_allocate(int widget, boolean redraw);
public static final synchronized native void gtk_widget_set_sensitive(int widget, boolean sensitive);
public static final synchronized native void gtk_widget_set_size_request(int widget, int width, int height);
public static final synchronized native void gtk_widget_set_state(int widget, int state);
public static final synchronized native void gtk_widget_show(int widget);
public static final synchronized native void gtk_widget_show_now(int widget);
public static final synchronized native void gtk_widget_size_allocate(int widget, GtkAllocation allocation);
public static final synchronized native void gtk_widget_size_request(int widget, GtkRequisition requisition);
public static final synchronized native void gtk_widget_style_get(int widget, byte[] property_name, int[] value, int null_terminator);
public static final synchronized native void gtk_widget_unrealize(int widget);
public static final synchronized native boolean gtk_window_activate_default(int window);
public static final synchronized native void gtk_window_add_accel_group(int window, int accel_group);
public static final synchronized native void gtk_window_deiconify(int handle);
public static final synchronized native int gtk_window_get_focus(int window);
public static final synchronized native void gtk_window_get_position(int handle, int[] x, int[] y);
public static final synchronized native void gtk_window_get_size(int handle, int[] x, int[] y);
public static final synchronized native void gtk_window_iconify(int handle);
public static final synchronized native void gtk_window_maximize(int handle);
public static final synchronized native void gtk_window_move(int handle, int x, int y);
public static final synchronized native int gtk_window_new(int type);
public static final synchronized native void gtk_window_present(int window);
public static final synchronized native void gtk_window_remove_accel_group(int window, int accel_group);
public static final synchronized native void gtk_window_resize(int handle, int x, int y);
public static final synchronized native void gtk_window_set_default(int window, int widget);
public static final synchronized native void gtk_window_set_destroy_with_parent(int window, boolean setting);
public static final synchronized native void gtk_window_set_modal(int window, boolean modal);
public static final synchronized native void gtk_window_set_resizable(int window, boolean resizable);
public static final synchronized native void gtk_window_set_title(int window, byte[] title);
public static final synchronized native void gtk_window_set_transient_for(int window, int parent);
public static final synchronized native void gtk_window_unmaximize(int handle);
public static final native void memmove(int dest, GtkTargetEntry src, int size);
public static final native void memmove(int dest, GtkAdjustment src);
public static final native void memmove(int dest, GtkStyle src);
public static final native void memmove(int dest, GdkEventButton src, int size);
public static final native void memmove(GtkColorSelectionDialog dest, int src);
public static final native void memmove(GtkFileSelection dest, int src);
public static final native void memmove(GdkDragContext dest, int src, int size);
public static final native void memmove(GtkSelectionData dest, int src, int size);
public static final native void memmove(GtkTargetPair dest, int src, int size);
public static final native void memmove(GtkStyle dest, int src);
public static final native void memmove(GtkCombo dest, int src);
public static final native void memmove(GtkAdjustment dest, int src);
public static final native void memmove(GdkColor dest, int src, int size);
public static final native void memmove(GdkEvent dest, int src, int size);
public static final native void memmove(GdkEventButton dest, int src, int size);
public static final native void memmove(GdkEventCrossing dest, int src, int size);
public static final native void memmove(GdkEventExpose dest, int src, int size);
public static final native void memmove(GdkEventFocus dest, int src, int size);
public static final native void memmove(GdkEventKey dest, int src, int size);
public static final native void memmove(GtkFixed dest, int src);
public static final native void memmove(int dest, GtkFixed src);
public static final native void memmove(GdkVisual dest, int src);
public static final native void memmove(GdkImage dest, int src);
public static final native void memmove(GdkRectangle dest, int src, int size);
public static final native void memmove(int dest, int[] src, int size);
public static final native void memmove(int dest, byte[] src, int size);
public static final native void memmove(int[] dest, byte[] src, int size);
public static final native void memmove(byte[] dest, int src, int size);
public static final native void memmove(char[] dest, int src, int size);
public static final native void memmove(int[] dest, int src, int size);
public static final synchronized native void pango_attr_list_unref(int list);
public static final synchronized native int pango_context_get_language(int context);
public static final synchronized native int pango_context_get_metrics(int context, int desc, int language);
public static final synchronized native void pango_context_list_families(int context, int[] families, int[] n_families);
public static final synchronized native void pango_context_set_language(int context, int language);
public static final synchronized native int pango_font_description_copy(int desc);
public static final synchronized native void pango_font_description_free(int desc);
public static final synchronized native int pango_font_description_from_string(byte[] str);
public static final synchronized native int pango_font_description_get_family(int desc);
public static final synchronized native int pango_font_description_get_size(int desc);
public static final synchronized native int pango_font_description_get_style(int desc);
public static final synchronized native int pango_font_description_get_weight(int desc);
public static final synchronized native int pango_font_description_new();
public static final synchronized native void pango_font_description_set_family(int desc, byte[] family);
public static final synchronized native void pango_font_description_set_size(int desc, int size);
public static final synchronized native void pango_font_description_set_stretch(int desc, int stretch);
public static final synchronized native void pango_font_description_set_style(int desc, int weight);
public static final synchronized native void pango_font_description_set_weight(int desc, int weight);
public static final synchronized native int pango_font_description_to_string(int desc);
public static final synchronized native int pango_font_face_describe(int face);
public static final synchronized native void pango_font_family_list_faces(int family, int[] faces, int[] n_faces);
public static final synchronized native int pango_font_metrics_get_approximate_char_width(int metrics);
public static final synchronized native int pango_font_metrics_get_ascent(int metrics);
public static final synchronized native int pango_font_metrics_get_descent(int metrics);
public static final synchronized native void pango_font_metrics_unref(int metrics);
public static final synchronized native int pango_language_from_string(byte[] language);
public static final synchronized native void pango_layout_get_size(int layout, int[] width, int[] height);
public static final synchronized native int pango_layout_new(int context);
public static final synchronized native void pango_layout_set_font_description(int context, int descr);
public static final synchronized native void pango_layout_set_text(int layout, byte[] text, int length);
public static final synchronized native void pango_layout_set_width(int layout, int width);
public static final synchronized native void pango_tab_array_free(int tab_array);
public static final synchronized native int pango_tab_array_new(int initial_size, boolean positions_in_pixels);
public static final synchronized native void pango_tab_array_set_tab(int tab_array, int tab_index, int alignment, int location);
public static final native int strlen(int str);
public static final synchronized native int XInternAtom(int display, byte[] name, boolean ifExists);

}
